﻿/*	VERSION:	1.3
	1.3		improved initialization of react.  This now avoids creating a redundant onUnload() when react.to already exists
	1.2		re-assigning reactions now destroys the previous reaction and reduces watch-reference count, before creating a new reaction and increasing watch-reference count  (external monad reference stays the same)
	1.1		renamed "evt" to "data"
				"evt" is generated by callback() for event output

DESCRIPTION: 
	This allows multiple things to react to a variable being changed.
	This does NOT work if that variable is actually a property.
	

evt: {
	oldVal: null,		// this contains this variable's previous value
	value: null			// this contains this variable's current value
}


USAGE: 
	#include "functions/watchVar.as"
	watchVar("myVar").from( myObj ).then = function( evt ){
		trace("* myVar changed to: " + evt.value );
	}
	myObj.myVar = 2;
	
	
	watchVar("myVar").then = function( evt ){
		trace("* myVar changed to: " + evt.value );
	}
	this.myVar = "merf";
	
	
	reaction = watchVar("myVar").from( myObj );
	reaction.then = function( evt ){
		trace("* myVar changed to: " + evt.value );
	}
	reaction.then = null;		// remove the event reaction  (will also remove the "watch" if nothing else is reacting to it)
	this.myVar = "merf";


HOW THIS WORKS: 
	For each unique combination of (obj + varName) a new watch() and a unique eventName are generated. The watch and eventName are associated
	Each time watch() triggers,  that event triggers within _global.WATCHVAR
	Additional requests for the same combination (obj + varName) recieve a new reaction to the same eventName
	
*/
#include "runFunc.as"
// #include "functions/eventSystem3.as"
// #include "functions/sendEvent.as"

runFunc(function(){
	var _this = this;
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	// SETUP
	
	#include "eventSystem3.as"
	if(!_this.addListener)		AsBroadcaster.initialize( _this );
	if(!react.to){
		var react = make_react( _this );		// param is optional
		var old_onUnload = _this.onUnload;
		_this.onUnload = function(){
			old_onUnload();
			sendEvent( "unload" );		// this will trigger react.unload()		... and trigger any external code listening for "unload" to occur here
		}// onUnload()
	}// if:  react doesn't exist
	
	
	
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	// INIT
	
	createGlobal();
	
	// create local watchVar()
	_this.watchVar = function( watchForVar ){
		if( !watchForVar )		return;
		
		var monad = {
			is_watchVar: true,		// allow external code to detect what kind of monad this is
			from: null
		};
		var within = null;
		var withinDefault = _this;		// used while "within" is null
		// var watchForVar;
		var reaction = {};
		
		
		// from()
		monad.from = function( newTarget ){
			if( newTarget instanceof Object === false )		return monad;
			// if newTarget is an object,  then use it
			within = newTarget || null;
			return monad;
		}// from()
		
		
		// then = 
		function get_then(){
			return reaction.then;
		}// get then
		function set_then( new_func ){
			var insideOfObj = within || withinDefault;
			
			// if a previous reaction already exists,  remove it
			if( reaction.then instanceof Function ){
				// destroy the previous reaction
				// reaction.then = null;
				reaction.disable();
				// decrease global refernces for this (obj + variable)
				WATCHVAR.remove( watchForVar, insideOfObj );
			}
			
			// if the input is a new function,  add a reaction
			if( new_func instanceof Function ){
				// create the watch and a new reaction
				reaction = WATCHVAR.add( watchForVar, insideOfObj, react );
				reaction.then = new_func;
			}
			/*	
			else{
				if(reaction.then === null)		return;
				reaction.then = null;
				// decrease global refernces for this (obj + variable)
				WATCHVAR.remove( watchForVar, insideOfObj );
			}
			*/
		}// set then
		monad.addProperty( "then", get_then, set_then );
		
		
		return monad;
	}// watchVar()		(local)
	
	
	
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	// HELPER FUNCTIONS
	
	function createGlobal(){
		if( _global.WATCHVAR )		return;
		
		_global.WATCHVAR = {};
		if(!WATCHVAR.addListener)		AsBroadcaster.initialize( WATCHVAR );
		var _this = WATCHVAR;
		#include "sendEvent.as"
		WATCHVAR.watchList = [];
		
		
		// creates a "watch" for this (varName + insideOfObj) if one doesn't already exist, and returns a react monad for it
		WATCHVAR.add = function( varName, insideOfObj, react ){
			if( !varName )		return;
			if( !insideOfObj )		return;
			if( !react )		return;
			
			var data = getWatch( varName, insideOfObj );
			var canWatch;
			
			
			// if:  not already watching this variable in this object
			if( data === null ){
				data = {
					insideOfObj: insideOfObj,		// reference to the object that is being watched for changes to varName
					varName: varName,						// watch() will detect changes to varName located inside of insideOfObj
					uid: Math.random(),					// a unique event ID,  used to create reactions to this specific combination of insideOfObj + varName
					eventName: "",							// this will be the unique event name generated by:  varName + uid
					references: 0								// this is how many reactions exist for this specific watch for (insideOfObj + varName),  when it becomes 0 this watch is removed
				}
				data.eventName = data.varName + data.uid;
				WATCHVAR.watchList.push( data );
				// create a "watch",   which sends a unique event,  which everything can react to
				var callback = function( varName, oldVal, newVal ){
					var evt = {
						oldVal: oldVal, 
						value: newVal
					}
					sendEvent( data.eventName, evt, WATCHVAR );
					return newVal;
				}// callback()
				canWatch = insideOfObj.watch( varName, callback );
			}// if:  not already watching this variable in this object
			
			
			// when the calling-movieClip is unloaded,  then decrease data.references  (we're using the calling-movieClip's "react" object)
			react.to("unload").then = function(){
				WATCHVAR.remove( varName, insideOfObj );
			}
			// keep track of how many things are reacting to this watch
			data.references += 1;
			// return an event reaction for this watch
			return react.to( data.eventName ).from( WATCHVAR );
		}// add()
		
		
		// decreases the reference count in the "data" object of this (varName + insideOfObj),  when references becomes 0 the corresponding watch() and "data" are removed and forgotten
		WATCHVAR.remove = function( varName, insideOfObj ){
			if( !varName )		return;
			if( !insideOfObj )		return;
			
			for(var i in WATCHVAR.watchList){
				if( WATCHVAR.watchList[i].varName === varName
				&&	WATCHVAR.watchList[i].insideOfObj === insideOfObj )
				{
					var data = WATCHVAR.watchList[i];
					data.references -= 1;
					if( data.references === 0 ){
						data.insideOfObj.unwatch( data.varName );
						WATCHVAR.watchList.splice( i, 1 );
					}
					if( data.references > 0 )			return data;
				}
			}// for each item in WATCHVAR.watchList
		}// remove
		
		
		// get the pre-existing "data" object for this (varName + insideOfObj) if one exists,  else return null
		function getWatch( varName, insideOfObj ){
			for(var i in WATCHVAR.watchList){
				if( WATCHVAR.watchList[i].varName === varName
				&&	WATCHVAR.watchList[i].insideOfObj === insideOfObj )
				{
					return WATCHVAR.watchList[i];
				}
			}// for each item in WATCHVAR.watchList
			return null;
		}// getWatch()
	}// createGlobal()
	
	
	
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
});// runFunc()